# Archivos de datos abiertos de Tecnosandias


Este archivo ZIP contiene archivos para estudiar e investigar sobre esta plataforma de participación.


## Núcleo

### moderated_users

* user_id: El ID único de la usuaria reportada
* blocked_at: Fecha y hora en que la se bloqueó a la usuaria
* about: El texto "Acerca de" incluido en el perfil de usuaria
* reasons: Una lista de las razones por las que se ha reportado el perfil de usuaria
* details: Los detalles de los informes de moderación
* block_reasons: La razón por la que administradora bloqueó a la usuaria
* blocking_user: El nombre de usuaria de la administradora que realizó el bloqueo


### users

* id: El identificador único de la usuaria
* name: El nombre que se muestra de la usuaria
* nickname: El nombre de usuaria de la usuaria
* about: El texto "Acerca de" incluido en el perfil de usuaria
* avatar_url: El avatar de la usuaria
* profile_url: La URL del perfil de la usuaria
* direct_messages_enabled: Si la usuaria permite mensajes directos o no
* deleted: Si la usuaria fue eliminada o no
* badge: La insignia de la usuaria
* groups: El ID y el nombre del grupo de usuarias


### metrics

* day: La fecha en la que se creó esta métrica
* metric_type: El tipo de métrica
* cumulative: El número total de métricas en este día
* quantity: El número de métricas en este día



## Espacios

### participatory_processes

* id: El identificador único del proceso
* title: El título del proceso
* slug: El nombre corto del proceso (usado para fines de identificación, para la URL)
* reference: La referencia única del proceso participativo
* created_at: La fecha en la que se creó este proceso participativo
* updated_at: La fecha de la última actualización de este proceso participativo
* published_at: La fecha en la que se publicó este proceso participativo
* follows_count: El número de usuarias que siguen este proceso participativo
* hashtag: La etiqueta que utiliza el proceso en Twitter/X
* short_description: Una breve descripción del proceso
* description: Una descripción larga del proceso
* promoted: Si el proceso está destacado o no
* url: La URL del proceso participativo
* subtitle: El subtítulo del proceso
* remote_hero_image_url: La URL de la imagen principal del proceso
* announcement: La información del anuncio/aviso (llamada)
* start_date: La fecha de inicio del proceso
* end_date: La fecha de finalización del proceso
* developer_group: El grupo promotor del proceso. Quien está promoviendo el proceso.
* local_area: El área de organización del proceso. Esto es el área de organización de la que depende este proceso.
* meta_scope: Los metadatos del ámbito territorial del proceso
* participatory_scope: El ámbito territorial de la participación del proceso
* participatory_structure: La estructura participativa del proceso. Esto es como se decide en el proceso.
* target: Las destinatarias del proceso. Quien está llamado a participar en el proceso.
* area: El área a la que pertenece el proceso
* participatory_process_group: El grupo del proceso, si forma parte de alguno
* scope: El ámbito territorial del proceso
* scopes_enabled: Si el ámbito territorial está habilitado o no
* participatory_process_type: El tipo del proceso


### assemblies

* id: El identificador único del resultado
* title: El título de la asamblea
* slug: El nombre corto de la asamblea (usado para fines de identificación, para la URL)
* reference: La referencia única de la asamblea
* created_at: La fecha en la que se creó esta asamblea
* updated_at: La fecha de la última actualización de esta asamblea
* published_at: La fecha en la que se publicó esta asamblea
* follows_count: El número de usuarias que siguen esta asamblea
* hashtag: La etiqueta que utiliza la asamblea en Twitter/X
* short_description: Una breve descripción de la asamblea
* description: Una descripción larga de la asamblea
* promoted: Si la asamblea está destacada o no
* url: La URL de la asamblea
* subtitle: El subtítulo de la asamblea
* remote_hero_image_url: La URL de la imagen principal de la asamblea
* remote_banner_image_url: La URL de la imagen de la cabecera (imagen principal) de la asamblea
* announcement: La información del anuncio/aviso (llamada)
* developer_group: El grupo de promotor de la asamblea
* local_area: El área de organización de la asamblea
* meta_scope: Los metadatos del ámbito territorial de la asamblea
* participatory_scope: El ámbito territorial de la participación de la asamblea
* purpose_of_action: El propósito de la acción de la asamblea
* composition: La composición de la asamblea
* duration: La duración de la asamblea
* participatory_structure: La estructura participativa de la asamblea
* target: El objetivo de la asamblea
* decidim_scope_id: El ámbito territorial de asamblea
* area: El área a la que corresponde la asamblea
* scope: El ámbito territorial de asamblea
* scopes_enabled: Si el ámbito territorial está habilitado o no
* included_at: La fecha en que la asamblea fue incluida en la plataforma
* closing_date: La fecha de cierre de la asamblea
* created_by: Quién creó esta asamblea
* creation_date: La fecha de creación de esta asamblea
* closing_date_reason: Por qué se cerró la asamblea
* internal_organisation: La organización interna de esta asamblea
* is_transparent: Si la asamblea es transparente o no
* special_features: Qué características especiales tiene esta asamblea
* twitter_handler: Controlador de redes sociales para Twitter/X
* instagram_handler: Controlador de redes sociales para Instagram
* facebook_handler: Controlador de redes sociales para Facebook
* youtube_handler: Controlador de redes sociales para YouTube
* github_handler: Controlador de redes sociales para GitHub
* created_by_other: El área a la que corresponde la asamblea
* assembly_type: El tipo de asamblea



## Componentes

### posts

* id: El identificador único de la publicación
* author: La información de la autoría
* title: El título de la publicación
* body: El contenido de la publicación
* created_at: La fecha en la que se creó esta publicación
* updated_at: La fecha de la última actualización de esta publicación
* published_at: La fecha en la que se publicó esta entrada en el blog
* endorsements_count: El número de adhesiones que tiene esta publicación
* comments_count: El número de comentarios que tiene esta publicación
* follows_count: El número de seguidoras que tiene esta publicación
* participatory_space: A qué espacio pertenece esta publicación (proceso participativo, asamblea, etc.)
* component: El componente al que pertenece la publicación
* url: La URL para esta publicación


### pages

* id: El identificador único de esta página
* title: El título de la página
* body: El contenido de la página
* created_at: La fecha en la que se creó esta página
* updated_at: La fecha de la última actualización de esta página
* participatory_space: A qué espacio pertenece esta página (proceso participativo, asamblea, etc.)
* component: El componente al que pertenece la página
* url: La URL para esta página



